//
//  Retrieving_the_Attendees_of_an_EventAppDelegate.m
//  Retrieving the Attendees of an Event
//
//  Created by Vandad Nahavandipoor on 24/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Retrieving_the_Attendees_of_an_EventAppDelegate.h"

@implementation Retrieving_the_Attendees_of_an_EventAppDelegate

@synthesize window = _window;

- (EKCalendar *) calDAVCalendarWithTitleContaining
                 :(NSString *)paramDescription{
  
  EKCalendar *result = nil;
  
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  for (EKCalendar *thisCalendar in eventStore.calendars){
    if (thisCalendar.type == EKCalendarTypeCalDAV){
      if ([thisCalendar.title 
           rangeOfString:paramDescription].location != NSNotFound){
        return thisCalendar;
      }
    }
  }
  
  return result;
  
}

- (void) enumerateTodayEvents{
  
  /* Określenie kalendarza, w którym będzie przeprowadzana operacja wyszukiwania. */
  EKCalendar *targetCalendar = 
    [self calDAVCalendarWithTitleContaining:@"vandad.np@gmail.com"];
  
  /* Jeżeli nie można znaleźć szukanego kalendarza CalDAV,
   wtedy operacja powinna zostać przerwana. */
  if (targetCalendar == nil){
    NSLog(@"Nie znaleziono żadnego kalendarza CalDAV.");
    return;
  }
  
  /* Przekazanie bazie danych kalendarzy tablicy kalendarzy, które mają zostać przeszukane. */
  NSArray *targetCalendars = [[NSArray alloc] 
                              initWithObjects:targetCalendar, nil];
  
  /* Utworzenie egzemplarza bazy danych kalendarzy. */
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  /* Data początkowa to dzień dzisiejszy. */
  NSDate *startDate = [NSDate date];
  
  /* Data końcowa to dzień jutrzejszy. */
  NSTimeInterval NSOneDay = 1 * 24 * 60 * 60;
  NSDate *endDate = [startDate dateByAddingTimeInterval:NSOneDay];
  
  /* Utworzenie predykatu, który następnie będzie przekazany
   bazie danych kalendarzy w celu pobrania wydarzeń. */
  NSPredicate *searchPredicate =
  [eventStore predicateForEventsWithStartDate:startDate
                                      endDate:endDate
                                    calendars:targetCalendars];
  
  /* Upewnienie się o prawidłowym utworzeniu predykatu. */
  if (searchPredicate == nil){
    NSLog(@"Nie udało się utworzyć predykatu wyszukiwania.");
    return;
  }
  
  /* Pobranie wszystkich wydarzeń o podanym czasie początkowym i końcowym. */
  NSArray *events = [eventStore eventsMatchingPredicate:searchPredicate];
  
  /* Tablica wartości NSString będących odpowiednikami wartości
   znajdujących się w typie wyliczeniowym EKParticipantRole. */
  NSArray *attendeeRole = [NSArray arrayWithObjects:
                           @"Unknown",
                           @"Required",
                           @"Optional",
                           @"Chair",
                           @"Non Participant",
                           nil];
  
  /* Tablica wartości NSString będących odpowiednikami wartości
   znajdujących się w typie wyliczeniowym EKParticipantStatus. */
  NSArray *attendeeStatus = [NSArray arrayWithObjects:
                             @"Unknown",
                             @"Pending",
                             @"Accepted",
                             @"Declined",
                             @"Tentative",
                             @"Delegated",
                             @"Completed",
                             @"In Process",
                             nil];
  
  /* Tablica wartości NSString będących odpowiednikami wartości
   znajdujących się w typie wyliczeniowym EKParticipantType. */
  NSArray *attendeeType = [NSArray arrayWithObjects:
                           @"Unknown",
                           @"Person",
                           @"Room",
                           @"Resource",
                           @"Group",
                           nil];
  
  /* Iteracja przez wszystkie wydarzenia i wyświetlenie w oknie konsoli informacji o nich. */
  if (events != nil){
    
    NSUInteger eventCounter = 0;
    for (EKEvent *thisEvent in events){
      
      eventCounter++;
      
      NSLog(@"Data początkowa wydarzenia %lu = %@",
            (unsigned long)eventCounter,
            thisEvent.startDate);
      
      NSLog(@"Data końcowa wydarzenia %lu = %@",
            (unsigned long)eventCounter,
            thisEvent.endDate);
      
      NSLog(@"Nazwa wydarzenia %lu = %@",
            (unsigned long)eventCounter,
            thisEvent.title);
      
      if (thisEvent.attendees == nil ||
          [thisEvent.attendees count] == 0){
        NSLog(@"Wydarzenie %lu nie posiada zdefiniowanych uczestników.",
              (unsigned long)eventCounter);
        continue;
      }
      
      NSUInteger attendeeCounter = 1;
      for (EKParticipant *participant in thisEvent.attendees){
        
        NSLog(@"Wydarzenie %lu, uczestnik %lu to = %@",
              (unsigned long)eventCounter,
              (unsigned long)attendeeCounter,
              participant.name);
        
        NSLog(@"Wydarzenie %lu, rola uczestnika %lu to = %@",
              (unsigned long)eventCounter,
              (unsigned long)attendeeCounter,
              [attendeeRole objectAtIndex:
               participant.participantRole]);
        
        NSLog(@"Wydarzenie %lu, status uczestnika %lu to = %@",
              (unsigned long)eventCounter,
              (unsigned long)attendeeCounter,
              [attendeeStatus objectAtIndex:
               participant.participantStatus]);
        
        NSLog(@"Wydarzenie %lu, typ uczestnika %lu = %@",
              (unsigned long)eventCounter,
              (unsigned long)attendeeCounter,
              [attendeeType objectAtIndex:
               participant.participantType]);
        
        NSLog(@"Wydarzenie %lu, adres URL uczestnika %lu to = %@",
              (unsigned long)eventCounter,
              (unsigned long)attendeeCounter,
              participant.URL);
        
        attendeeCounter++;
        
      }
      
    } /* for (EKEvent *Event in Events){ */
    
  } else {
    NSLog(@"Tablica wydarzeń jest pusta.");
  }
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  [self enumerateTodayEvents];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
